#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define DEFORM_SIZE 245

#define FOND_Z (1.f)
// fond
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{1.f,1.f, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{240.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{240.f/FOND_Z,240.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{1.f,240.f/FOND_Z,1.f/FOND_Z}};

// 1999
static GrVertex Text1 = {185,200.5,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{74.f,94.f, 1.f/FOND_Z}};
static GrVertex Text2 = {465,200.5,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{186.f,94,1.f/300.f}};
static GrVertex Text3 = {465, 279.5,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{186.f,140.f,1.f/FOND_Z}};
static GrVertex Text4 = {185, 279.5,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{74.f,140.f,1.f/FOND_Z}};

// Arf party
static GrVertex Text5 = {75,174,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{38.f,72.f, 1.f/FOND_Z}};
static GrVertex Text6 = {538,174,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{220.f,72,1.f/300.f}};
static GrVertex Text7 = {538, 306,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{220.f,164.f,1.f/FOND_Z}};
static GrVertex Text8 = {75, 306,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{38.f,164.f,1.f/FOND_Z}};

// Scorpion
static GrVertex Text9 = {22.5f,140,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{8.f,0.f, 1.f/FOND_Z}};
static GrVertex Text10 = {617.5f,140,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{246.f,0,1.f/300.f}};
static GrVertex Text11 = {617.5f, 215,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{246.f,40.f,1.f/FOND_Z}};
static GrVertex Text12 = {22.5f, 215,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{8.f,40.f,1.f/FOND_Z}};

// the spirit
static GrVertex Text13 = {82.5f,220,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{30.f,68.f, 1.f/FOND_Z}};
static GrVertex Text14 = {557.5f,220,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{220.f,68,1.f/300.f}};
static GrVertex Text15 = {557.5f, 261,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{220.f,90.f,1.f/FOND_Z}};
static GrVertex Text16 = {82.5f, 261,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{30.f,90.f,1.f/FOND_Z}};

// the demo
static GrVertex Text17 = {82.5f,220,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{30.f,132.f, 1.f/FOND_Z}};
static GrVertex Text18 = {557.5f,220,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{220.f,132,1.f/300.f}};
static GrVertex Text19 = {557.5f, 261,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{220.f,154.f,1.f/FOND_Z}};
static GrVertex Text20 = {82.5f, 261,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{30.f,154.f,1.f/FOND_Z}};

static DWORD DeformTab[256*256]; 

//#define TUNNEL_2D

#ifdef TUNNEL_2D

static WORD TmpBuff[65536];
static WORD DistTab[256][256];
static WORD TanTab[256][256];
#define POS_X (128.f)
#define POS_Y (128.f)

#endif

void LInit_Deform()
{
  int Cpt1, Cpt2;
#ifdef TUNNEL_2D
  double DistTmp, TanTmp;
#endif
  
  for(Cpt1=0;Cpt1<256;Cpt1++)
    {
      for(Cpt2=0;Cpt2<256;Cpt2++)
	{
	  DeformTab[Cpt1*256+Cpt2]
				//= (DWORD)(10+9*sin(Cpt1*PI2*6/256))*256+10+9*sin(Cpt2*PI2*6/256);
	    = (DWORD)(7+6*sin(Cpt1*PI2*6/256))*256+7+6*sin(Cpt2*PI2*6/256);
	}
    }
  
  
#ifdef TUNNEL_2D
  for(Cpt1=0;Cpt1<256;Cpt1++)
    {
      for(Cpt2=0;Cpt2<256;Cpt2++)
	{
	  DistTmp = sqrt((Cpt1-128.f)*(Cpt1-128.f)+(Cpt2-128.f)*(Cpt2-128.f))*1.41;
	  //DistTmp = 4000/sqrt((Cpt1-POS_X)*(Cpt1-POS_X)+(Cpt2-POS_Y)*(Cpt2-POS_Y))*1.41;
	  TanTmp = (atan2(Cpt1-POS_X, Cpt2-POS_Y)/3.1415927*128.+128.);
	  DistTab[Cpt1][Cpt2] = (WORD)(DistTmp * (1. + cos(TanTmp*PI2*5./256.)/4.))%256;
	  TanTab[Cpt1][Cpt2] = (WORD)(TanTmp * 1.f)%256;
	}
    }
#endif

	PrepareTextureFromArray(g_PicImg1999, 256, 256, &g_TextureImg1999);
	PrepareTextureFromArray(g_PicArf, 256, 256, &g_TextureArf);
	PrepareTextureFromArray(g_PicScorpion, 256, 256, &g_TextureScorpion);
}

void QInit_Deform()
{
  grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
  grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
  grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
		       GR_BLEND_ONE, GR_BLEND_ZERO);
  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
  grCullMode(GR_CULL_DISABLE);
  
  grChromakeyMode(GR_CHROMAKEY_DISABLE);
  grFogMode(GR_FOG_DISABLE);
  
  g_TextureBuff.info.format = GR_TEXFMT_RGB_565;
  DownloadTexture(&g_TextureImg1999);
  DownloadTexture(&g_TextureArf);
  DownloadTexture(&g_TextureScorpion);
  
  grConstantColorValue(0x80000000);
}

void Effect_Deform()
{
  DWORD Cpt1, Cpt2;
  DWORD x,y; // deform pos
  
  WORD *pBuffer = g_FrameBuf3d;
  DWORD *pStartOfLine;
#ifdef TUNNEL_2D
  WORD *pPicTmp = TmpBuff;//g_PicMeta;
#else
  WORD *pPicTmp = g_PicGlyphs;
#endif
  DWORD dwTmp, dwTmp2;
  
  DWORD SizeTmp;
#ifdef TUNNEL_2D
  DWORD Img1;

  Img1 = g_demostate.TickInEffect/8;

  for(Cpt1=0;Cpt1<65536;Cpt1++)
    {
      TmpBuff[Cpt1] = g_PicGlyphs[
				((DistTab[0][Cpt1]+Img1)&255)
				+ 256*((TanTab[0][Cpt1]+Img1)&255)
      ];
    }
#endif

	x = (g_demostate.TickInEffect/16)&255;
	y = (g_demostate.TickInEffect/16)&255;

  pStartOfLine = DeformTab + y*256;

  for(Cpt1=0;Cpt1<DEFORM_SIZE;Cpt1++)
    {
      if (y==256)
	pStartOfLine = DeformTab;

      for(Cpt2=0;Cpt2<DEFORM_SIZE;Cpt2++)
	{
	  *(pBuffer++) = (pPicTmp++)[pStartOfLine[(Cpt2+x)&255]];
	}
      pBuffer += (256-DEFORM_SIZE);
      pPicTmp += (256-DEFORM_SIZE);
      y++;
      pStartOfLine += 256;
    }

  SizeTmp = 10+9*SinTable[g_demostate.TickInEffect&8191];
  Fond1.tmuvtx[0].sow = SizeTmp;
  Fond2.tmuvtx[0].sow = DEFORM_SIZE-SizeTmp;
  Fond3.tmuvtx[0].sow = DEFORM_SIZE-SizeTmp;
  Fond4.tmuvtx[0].sow = SizeTmp;

  Fond1.tmuvtx[0].tow = SizeTmp;
  Fond2.tmuvtx[0].tow = SizeTmp;
  Fond3.tmuvtx[0].tow = DEFORM_SIZE-SizeTmp;
  Fond4.tmuvtx[0].tow = DEFORM_SIZE-SizeTmp;
  
  grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
		      g_TextureBuff.evenOdd, &g_TextureBuff.info);

  SelectTexture(g_TextureBuff);
  grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
		       GR_BLEND_ONE, GR_BLEND_ZERO);

  switch(g_demostate.midas_status.position)
  {
  case 0:
	  if (g_demostate.TickInPattern<1000)
	  {
		  dwTmp2 = 256*(g_demostate.TickInPattern)/1000;
		  grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
		  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			  GR_COMBINE_FACTOR_LOCAL,
			  GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	  }
	  else
	  {
		  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			  GR_COMBINE_FACTOR_ONE,
			  GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	  }
	  break;
  case 2:
  case 4:
	  if (g_demostate.TickInPattern<1000)
	  {
		  dwTmp2 = 256*(1000-g_demostate.TickInPattern)/1000;
		  grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
		  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
			  GR_COMBINE_FACTOR_ONE,
			  GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	  }
	  else
	  {
		  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			  GR_COMBINE_FACTOR_ONE,
			  GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	  }
	  break;
  case 5:
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_LOCAL,
			GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp2 = 256*(5000-g_demostate.TickInPattern)/2500;
		dwTmp2 = CLIP_DW(dwTmp2);
		grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
	  break;
  case 6:
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
			GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXTRUE);
		dwTmp2 = 256*(g_demostate.TickInPattern)/5000;
		dwTmp2 = CLIP_DW(dwTmp2);
		grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
		break;
  default:
	  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		  GR_COMBINE_FACTOR_ONE,
		  GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
  }

  grDrawTriangle(&Fond1, &Fond2, &Fond3);
  grDrawTriangle(&Fond3, &Fond4, &Fond1);

  //

	grAlphaBlendFunction(GR_BLEND_ONE_MINUS_DST_COLOR, GR_BLEND_ONE_MINUS_SRC_COLOR,
		GR_BLEND_ONE, GR_BLEND_ZERO);

	switch(g_demostate.midas_status.position)
	{
	case 0:
		SelectTexture(g_TextureImg1999);
		if (g_demostate.TickInPattern<2500) // fade in; scaling
		{
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_LOCAL,
				GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			dwTmp2 = 256*g_demostate.TickInPattern/2500;
			dwTmp2 = CLIP_DW(dwTmp2);
			grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
			dwTmp = (140 + 180*(2500-g_demostate.TickInPattern)/2500);
			Text1.x = 320 - dwTmp;
			Text2.x = 320 + dwTmp;
			Text3.x = 320 + dwTmp;
			Text4.x = 320 - dwTmp;
		}
		else
		{
			if (g_demostate.TickInPattern<4500) // normal display
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
			else // fade out
			{
				dwTmp2 = 256*(5500-g_demostate.TickInPattern)/1000;
				dwTmp2 = CLIP_DW(dwTmp2);
				grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
		}
		grDrawTriangle(&Text1, &Text2, &Text3);
		grDrawTriangle(&Text3, &Text4, &Text1);
		break;
	case 1:
		SelectTexture(g_TextureArf);
		if (g_demostate.TickInPattern<2500) // fade in; scaling
		{
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_LOCAL,
				GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			dwTmp2 = 256*g_demostate.TickInPattern/2500;
			dwTmp2 = CLIP_DW(dwTmp2);
			grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
			dwTmp = (140 + 180*(2500-g_demostate.TickInPattern)/2500);
			Text5.x = 320 - dwTmp;
			Text6.x = 320 + dwTmp;
			Text7.x = 320 + dwTmp;
			Text8.x = 320 - dwTmp;
		}
		else
		{
			if (g_demostate.TickInPattern<4500) // normal display
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
			else // fade out
			{
				dwTmp2 = 256*(5500-g_demostate.TickInPattern)/1000;
				dwTmp2 = CLIP_DW(dwTmp2);
				grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
		}
		grDrawTriangle(&Text5, &Text6, &Text7);
		grDrawTriangle(&Text7, &Text8, &Text5);
		break;
	case 2: // Scorpion : the spirit
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		SelectTexture(g_TextureScorpion);
		grDrawTriangle(&Text9, &Text10, &Text11);
		grDrawTriangle(&Text11, &Text12, &Text9);
		if (g_demostate.TickInPattern>2500) // the spirit
		{
			if (g_demostate.TickInPattern<5000) // is fading in
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				dwTmp2 = 256*(g_demostate.TickInPattern-2500)/2500;
				dwTmp2 = CLIP_DW(dwTmp2);
				grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
				dwTmp = (235 + 85*(5000-g_demostate.TickInPattern)/2500);
				Text13.x = 320 - dwTmp;
				Text14.x = 320 + dwTmp;
				Text15.x = 320 + dwTmp;
				Text16.x = 320 - dwTmp;
			}
			else
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
			grDrawTriangle(&Text13, &Text14, &Text15);
			grDrawTriangle(&Text15, &Text16, &Text13);
		} // end the spirit
		break;
	case 3:
		SelectTexture(g_TextureScorpion);
		if (g_demostate.TickInPattern<2500)
		{
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_ONE,
				GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		}
		else
		{
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_LOCAL,
				GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				dwTmp2 = 256*(5000-g_demostate.TickInPattern)/2500;
				dwTmp2 = CLIP_DW(dwTmp2);
				grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
		}
		grDrawTriangle(&Text9, &Text10, &Text11);
		grDrawTriangle(&Text11, &Text12, &Text9);
		grDrawTriangle(&Text13, &Text14, &Text15);
		grDrawTriangle(&Text15, &Text16, &Text13);
		break;
	case 4: // Scorpion : the demo
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		SelectTexture(g_TextureScorpion);
		grDrawTriangle(&Text9, &Text10, &Text11);
		grDrawTriangle(&Text11, &Text12, &Text9);
		if (g_demostate.TickInPattern>2500) // the spirit
		{
			if (g_demostate.TickInPattern<5000) // is fading in
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				dwTmp2 = 256*(g_demostate.TickInPattern-2500)/2500;
				dwTmp2 = CLIP_DW(dwTmp2);
				grConstantColorValue(dwTmp2|(dwTmp2*256)|(dwTmp2*65536));
				dwTmp = (235 + 85*(5000-g_demostate.TickInPattern)/2500);
				Text17.x = 320 - dwTmp;
				Text18.x = 320 + dwTmp;
				Text19.x = 320 + dwTmp;
				Text20.x = 320 - dwTmp;
			}
			else
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
			grDrawTriangle(&Text17, &Text18, &Text19);
			grDrawTriangle(&Text19, &Text20, &Text17);
		} // end the spirit
		break;
	case 5:
		SelectTexture(g_TextureScorpion);
		if (g_demostate.TickInPattern<2500)
		{
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_ONE,
				GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		}
		else
		{
		}
		grDrawTriangle(&Text9, &Text10, &Text11);
		grDrawTriangle(&Text11, &Text12, &Text9);
		grDrawTriangle(&Text17, &Text18, &Text19);
		grDrawTriangle(&Text19, &Text20, &Text17);
		break;
	}

	/*
	if (g_demostate.TickInEffect<5500) // 1999
	{
		SelectTexture(g_TextureImg1999);
		if (g_demostate.TickInEffect<2500) // Come
		{
			grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_LOCAL,
				GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			dwTmp2 = 256*g_demostate.TickInEffect/2500;
			grConstantColorValue(dwTmp2+dwTmp2*256+dwTmp2*65536);
			// length = 280 ; length/2 = 140 ; todo : 320 -> 140 ; 320 - 140 = 180
			dwTmp = (140 + 180*(2500-g_demostate.TickInEffect)/2500);
			Text1.x = 320 - dwTmp;
			Text2.x = 320 + dwTmp;
			Text3.x = 320 + dwTmp;
			Text4.x = 320 - dwTmp;
		}
		else
		{
			if (g_demostate.TickInEffect<4500) // normal display
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
			else // fade out
			{
				dwTmp2 = 256*(5500-g_demostate.TickInEffect)/1000;
				grConstantColorValue(dwTmp2+dwTmp2*256+dwTmp2*65536);
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
			}
		}

		grDrawTriangle(&Text1, &Text2, &Text3);
		grDrawTriangle(&Text3, &Text4, &Text1);
	}
	else
	{
		if (g_demostate.TickInEffect<11000) // ARF! Party
		{
			SelectTexture(g_TextureArf);
			if (g_demostate.TickInEffect<8000) // Come
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				dwTmp2 = 256*(g_demostate.TickInEffect-5500)/2500;
				grConstantColorValue(dwTmp2+dwTmp2*256+dwTmp2*65536);
				// length = 462 ; length/2 = 231 ; todo : 320 -> 231 ; 320 - 150 = 89
				dwTmp = (231 + 89*(8000-g_demostate.TickInEffect)/2500);
				Text5.x = 320 - dwTmp;
				Text6.x = 320 + dwTmp;
				Text7.x = 320 + dwTmp;
				Text8.x = 320 - dwTmp;
			}
			else
			{
				if (g_demostate.TickInEffect<10000) // normal display
				{
					grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				}
				else // fade out
				{
					dwTmp2 = 256*(11000-g_demostate.TickInEffect)/1000;
					grConstantColorValue(dwTmp2+dwTmp2*256+dwTmp2*65536);
					grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_LOCAL,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				}
			}
			grDrawTriangle(&Text5, &Text6, &Text7);
			grDrawTriangle(&Text7, &Text8, &Text5);
		}
		else
		{
			if (g_demostate.TickInEffect<22000) // Scorpion : The spirit ( > 12000 )
			{
				if (g_demostate.TickInEffect<19500)
				{
					grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				}
				else
				{
						grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
							GR_COMBINE_FACTOR_LOCAL,
							GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
						dwTmp2 = 256*(22000-g_demostate.TickInEffect)/2500;
						grConstantColorValue(dwTmp2+dwTmp2*256+dwTmp2*65536);
				}
				SelectTexture(g_TextureScorpion);
				grDrawTriangle(&Text9, &Text10, &Text11);
				grDrawTriangle(&Text11, &Text12, &Text9);
				if (g_demostate.TickInEffect>13000)
				{
					if (g_demostate.TickInEffect<15500)
					{
						grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
							GR_COMBINE_FACTOR_LOCAL,
							GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
						dwTmp2 = 256*(g_demostate.TickInEffect-13000)/2500;
						grConstantColorValue(dwTmp2+dwTmp2*256+dwTmp2*65536);
					}
					grDrawTriangle(&Text13, &Text14, &Text15);
					grDrawTriangle(&Text15, &Text16, &Text13);
				}
			}
			else // Scorpion : The Demo // > 22000
			{
				grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
				SelectTexture(g_TextureScorpion);
				grDrawTriangle(&Text9, &Text10, &Text11);
				grDrawTriangle(&Text11, &Text12, &Text9);
				if (g_demostate.TickInEffect>23000)
				{
					if (g_demostate.TickInEffect<25500)
					{
						grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
							GR_COMBINE_FACTOR_LOCAL,
							GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
						dwTmp2 = 256*(g_demostate.TickInEffect-23000)/2500;
						grConstantColorValue(dwTmp2+dwTmp2*256+dwTmp2*65536);
					}
					grDrawTriangle(&Text17, &Text18, &Text19);
					grDrawTriangle(&Text19, &Text20, &Text17);
				}
			}
		}
	}*/

}

void ByeBye_Deform()
{
	FreeTexture(&g_TextureScorpion);
	FreeTexture(&g_TextureArf);
	FreeTexture(&g_TextureImg1999);
}
